package gov.va.med.mhv.health.web.form.bean;

import gov.va.med.mhv.health.dto.ImmunizationDTO;
import gov.va.med.mhv.health.dto.ImmunizationReactionDTO;
import gov.va.med.mhv.health.enums.ImmunizationEnumeration;
import gov.va.med.mhv.health.enums.OtherSymptomEnumeration;
import gov.va.med.mhv.health.enums.ReactionsEnumeration;
import gov.va.med.mhv.health.enums.VaccinationMethodEnumeration;
import gov.va.med.mhv.health.util.CommonUtility;

import java.util.List;

public class Immunization  extends ImmunizationDTO{
	
	private static final long serialVersionUID = -5696776093748074860L;
	
	public String getDisplayDateReceived() {
		return  CommonUtility.dateToString(getDateReceived(), "MM/dd/yyyy");
	}
	
	public String getDashboardDate() {
		return  CommonUtility.dateToString(getDateReceived(), "EEE MM/dd/yyyy");
	}

	
	public String getDisplayReaction() {
		StringBuffer allReactions=new StringBuffer();
		List<ImmunizationReactionDTO> reactions =getReactions();
		if(reactions != null){
			int countReactions = reactions.size();
			for(ImmunizationReactionDTO dto :reactions){
				allReactions.append(ReactionsEnumeration.valueOf(dto.getReactionTypeCode()).getDescription());
				if(countReactions != 1 || getReactionTypeCode() != null){
					allReactions.append(", ");
				}
				--countReactions;
			}
		}
		if(getReactionTypeCode() != null){
			allReactions.append(OtherSymptomEnumeration.valueOf(getReactionTypeCode()).getDescription());
		}
		return  allReactions.toString();
	}
	
	
    public String getDisplayVaccinationType(){
    	String vaccinationType=null;
    	if(getVaccinationTypeCode() != null){
    		vaccinationType=ImmunizationEnumeration.getDesc(getVaccinationTypeCode());
    	}
    	return vaccinationType;
    }
    
    public String getDisplayVaccinationMethod(){
    	
    	String method=null;
    	if(getVaccinationMethod() != null){
    		method=VaccinationMethodEnumeration.valueOf(getVaccinationMethod()).getDescription();
    	}
    	return method;
    }
}
